/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModOrigin;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xaero.deallocator.ByteBufferDeallocator;
import xaero.map.CrashHandler;
import xaero.map.MapLimiter;
import xaero.map.MapRunner;
import xaero.map.WorldMapClient;
import xaero.map.cache.UnknownBlockStateCache;
import xaero.map.common.config.CommonConfig;
import xaero.map.common.config.CommonConfigIO;
import xaero.map.common.config.CommonConfigInit;
import xaero.map.controls.ControlsRegister;
import xaero.map.effects.EffectsRegister;
import xaero.map.element.MapElementRenderHandler;
import xaero.map.events.CommonEvents;
import xaero.map.events.Events;
import xaero.map.events.FMLCommonEvents;
import xaero.map.events.FMLEvents;
import xaero.map.events.ModCommonEvents;
import xaero.map.events.ModEvents;
import xaero.map.file.OldFormatSupport;
import xaero.map.file.export.PNGExporter;
import xaero.map.graphics.GLObjectDeleter;
import xaero.map.graphics.TextureUploadBenchmark;
import xaero.map.message.WorldMapMessage;
import xaero.map.message.WorldMapMessageHandler;
import xaero.map.message.WorldMapMessageRegister;
import xaero.map.message.server.ServerWorldMapPacketConsumer;
import xaero.map.misc.Internet;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.WaypointSymbolCreator;
import xaero.map.patreon.Patreon;
import xaero.map.pool.MapTilePool;
import xaero.map.pool.TextureUploadPool;
import xaero.map.pool.buffer.TextureDirectBufferPool;
import xaero.map.radar.tracker.PlayerTrackerMapElementRenderer;
import xaero.map.radar.tracker.PlayerTrackerMenuRenderer;
import xaero.map.radar.tracker.system.PlayerTrackerSystemManager;
import xaero.map.radar.tracker.system.impl.SyncedPlayerTrackerSystem;
import xaero.map.region.OverlayManager;
import xaero.map.resource.ShaderResourceReloadListener;
import xaero.map.server.WorldMapServer;
import xaero.map.server.mods.SupportServerMods;
import xaero.map.server.player.ServerPlayerTickHandler;
import xaero.map.settings.ModOptions;
import xaero.map.settings.ModSettings;

public class WorldMap
implements ClientModInitializer,
DedicatedServerModInitializer {
    private static boolean loaded = false;
    public static WorldMap INSTANCE;
    public static int MINIMAP_COMPATIBILITY_VERSION;
    public static Logger LOGGER;
    private static final String versionID_minecraft = "1.20";
    private static final String versionID_mod = "1.37.2";
    public static final String versionID = "1.20_1.37.2_fabric";
    public static int newestUpdateID;
    public static boolean isOutdated;
    public static String fileLayoutID;
    public static String latestVersion;
    public static String latestVersionMD5;
    public static Events events;
    public static FMLEvents fmlEvents;
    public static ModEvents modEvents;
    public static ControlsRegister controlsRegister;
    public static WaypointSymbolCreator waypointSymbolCreator;
    public static ByteBufferDeallocator bufferDeallocator;
    public static TextureUploadBenchmark textureUploadBenchmark;
    public static OverlayManager overlayManager;
    public static OldFormatSupport oldFormatSupport;
    public static PNGExporter pngExporter;
    public static TextureUploadPool.Normal normalTextureUploadPool;
    public static TextureUploadPool.Compressed compressedTextureUploadPool;
    public static TextureUploadPool.BranchUpdate branchUpdatePool;
    public static TextureUploadPool.BranchUpdate branchUpdateAllocatePool;
    public static TextureUploadPool.BranchDownload branchDownloadPool;
    public static TextureUploadPool.SubsequentNormal subsequentNormalTextureUploadPool;
    public static TextureDirectBufferPool textureDirectBufferPool;
    public static MapTilePool tilePool;
    public static MapLimiter mapLimiter;
    public static UnknownBlockStateCache unknownBlockStateCache;
    public static GLObjectDeleter glObjectDeleter;
    public static MapRunner mapRunner;
    public static Thread mapRunnerThread;
    public static CrashHandler crashHandler;
    public static final class_2960 guiTextures;
    public static ModSettings settings;
    public static int globalVersion;
    public static WorldMapClient worldMapClient;
    private boolean loadLaterNeeded;
    private boolean loadLaterDone;
    public static WorldMapServer worldmapServer;
    private Throwable firstStageError;
    public static MapElementRenderHandler mapElementRenderHandler;
    public static ServerPlayerTickHandler serverPlayerTickHandler;
    public static PlayerTrackerSystemManager playerTrackerSystemManager;
    public static PlayerTrackerMapElementRenderer trackedPlayerRenderer;
    public static PlayerTrackerMenuRenderer trackedPlayerMenuRenderer;
    public static WorldMapMessageHandler messageHandler;
    public static CommonEvents commonEvents;
    public static FMLCommonEvents fmlCommonEvents;
    public static File modJAR;
    public static File configFolder;
    public static File optionsFile;
    public static File saveFolder;
    public static CommonConfigIO commonConfigIO;
    public static CommonConfig commonConfig;

    public WorldMap() {
        new CommonConfigInit().init("xaeroworldmap-common.txt");
    }

    public void onInitializeClient() {
        INSTANCE = this;
        try {
            this.loadCommon();
            this.loadClient();
        }
        catch (Throwable e) {
            this.firstStageError = e;
        }
    }

    public void onInitializeServer() {
        INSTANCE = this;
        try {
            this.loadCommon();
            this.loadServer();
        }
        catch (Throwable e) {
            this.firstStageError = e;
        }
    }

    private void loadClient() throws IOException, ClassNotFoundException, NoSuchMethodException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Object patreonEntry;
        ModOrigin origin;
        Path modFile;
        LOGGER.info("Loading Xaero's World Map - Stage 1/2");
        events = new Events();
        fmlEvents = new FMLEvents();
        modEvents = new ModEvents();
        trackedPlayerRenderer = PlayerTrackerMapElementRenderer.Builder.begin().build();
        trackedPlayerMenuRenderer = PlayerTrackerMenuRenderer.Builder.begin().setRenderer(trackedPlayerRenderer).build();
        ModOptions.init();
        ModContainer modContainer = FabricLoader.getInstance().getModContainer("xaeroworldmap").orElse(null);
        if (modContainer == null) {
            modContainer = FabricLoader.getInstance().getModContainer("xaerodev").orElse(null);
        }
        Path path = modFile = (origin = modContainer.getOrigin()).getKind() == ModOrigin.Kind.PATH ? (Path)origin.getPaths().get(0) : null;
        if (modFile == null) {
            try {
                Class<?> quiltLoaderClass = Class.forName("org.quiltmc.loader.api.QuiltLoader");
                Method quiltGetModContainerMethod = quiltLoaderClass.getDeclaredMethod("getModContainer", String.class);
                Class<?> quiltModContainerAPIClass = Class.forName("org.quiltmc.loader.api.ModContainer");
                Method quiltGetSourcePathsMethod = quiltModContainerAPIClass.getDeclaredMethod("getSourcePaths", new Class[0]);
                Object quiltModContainer = ((Optional)quiltGetModContainerMethod.invoke(null, modContainer.getMetadata().getId())).orElse(null);
                List paths = (List)quiltGetSourcePathsMethod.invoke(quiltModContainer, new Object[0]);
                if (!paths.isEmpty() && !((List)paths.get(0)).isEmpty()) {
                    modFile = (Path)((List)paths.get(0)).get(0);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException quiltLoaderClass) {
                // empty catch block
            }
        }
        worldMapClient = new WorldMapClient();
        worldMapClient.preInit(modContainer.getMetadata().getId());
        String fileName = modFile.getFileName().toString();
        if (fileName.endsWith(".jar")) {
            modJAR = modFile.toFile();
        }
        Path gameDir = WorldMap.getGameDir();
        Path config = FabricLoader.getInstance().getConfigDir();
        configFolder = config.toFile();
        optionsFile = config.resolve("xaeroworldmap.txt").toFile();
        saveFolder = gameDir.resolve("XaeroWorldMap").toFile();
        Path oldSaveFolder3 = config.getParent().resolve("XaeroWorldMap");
        File oldOptionsFile = gameDir.resolve("xaeroworldmap.txt").toFile();
        File oldSaveFolder = gameDir.resolve("mods").resolve("XaeroWorldMap").toFile();
        File oldSaveFolder2 = gameDir.resolve("config").resolve("XaeroWorldMap").toFile();
        if (oldOptionsFile.exists() && !optionsFile.exists()) {
            Files.move(oldOptionsFile.toPath(), optionsFile.toPath(), new CopyOption[0]);
        }
        if (oldSaveFolder.exists() && !saveFolder.exists()) {
            Files.move(oldSaveFolder.toPath(), saveFolder.toPath(), new CopyOption[0]);
        }
        if (oldSaveFolder2.exists() && !saveFolder.exists()) {
            Files.move(oldSaveFolder2.toPath(), saveFolder.toPath(), new CopyOption[0]);
        }
        if (oldSaveFolder3.toFile().exists() && !saveFolder.exists()) {
            Files.move(oldSaveFolder3, saveFolder.toPath(), new CopyOption[0]);
        }
        if (!saveFolder.exists()) {
            Files.createDirectories(saveFolder.toPath(), new FileAttribute[0]);
        }
        settings = new ModSettings();
        settings.loadSettings();
        Patreon.checkPatreon();
        Internet.checkModVersion();
        if (isOutdated && (patreonEntry = Patreon.getMods().get(fileLayoutID)) != null) {
            Patreon.setModInfo(patreonEntry, modJAR, versionID, latestVersion, latestVersionMD5, () -> {
                ModSettings.ignoreUpdate = newestUpdateID;
                try {
                    settings.saveSettings();
                }
                catch (IOException e) {
                    LOGGER.error("suppressed exception", (Throwable)e);
                }
            });
            Patreon.addOutdatedMod(patreonEntry);
        }
        waypointSymbolCreator = new WaypointSymbolCreator();
        controlsRegister = new ControlsRegister();
        bufferDeallocator = new ByteBufferDeallocator();
        tilePool = new MapTilePool();
        overlayManager = new OverlayManager();
        oldFormatSupport = new OldFormatSupport();
        pngExporter = new PNGExporter(configFolder.toPath().getParent().resolve("map exports"));
        mapLimiter = new MapLimiter();
        normalTextureUploadPool = new TextureUploadPool.Normal(256);
        compressedTextureUploadPool = new TextureUploadPool.Compressed(256);
        branchUpdatePool = new TextureUploadPool.BranchUpdate(256, false);
        branchUpdateAllocatePool = new TextureUploadPool.BranchUpdate(256, true);
        branchDownloadPool = new TextureUploadPool.BranchDownload(256);
        textureDirectBufferPool = new TextureDirectBufferPool();
        subsequentNormalTextureUploadPool = new TextureUploadPool.SubsequentNormal(256);
        textureUploadBenchmark = new TextureUploadBenchmark(512, 512, 512, 256, 256, 256, 256);
        unknownBlockStateCache = new UnknownBlockStateCache();
        glObjectDeleter = new GLObjectDeleter();
        crashHandler = new CrashHandler();
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new ShaderResourceReloadListener());
        mapRunner = new MapRunner();
        mapRunnerThread = new Thread(mapRunner);
        mapRunnerThread.start();
        this.loadLaterNeeded = true;
    }

    public static Path getGameDir() {
        return FabricLoader.getInstance().getGameDir().normalize();
    }

    public void tryLoadLater() {
        if (this.loadLaterDone) {
            return;
        }
        if (this.firstStageError != null) {
            throw new RuntimeException(this.firstStageError);
        }
        if (!this.loadLaterNeeded) {
            return;
        }
        this.loadLaterDone = true;
        LOGGER.info("Loading Xaero's World Map - Stage 2/2");
        try {
            settings.findMapItem();
            worldMapClient.postInit();
            settings.updateRegionCacheHashCode();
            playerTrackerSystemManager.register("map_synced", new SyncedPlayerTrackerSystem());
            SupportMods.load();
            mapElementRenderHandler = MapElementRenderHandler.Builder.begin().build();
            oldFormatSupport.loadStates();
        }
        catch (Throwable e) {
            LOGGER.error("error", e);
            crashHandler.setCrashedBy(e);
        }
        loaded = true;
    }

    private void loadServer() {
        worldmapServer = new WorldMapServer();
        worldmapServer.load();
        this.loadLaterNeeded = true;
    }

    private void loadCommon() {
        messageHandler = new WorldMapMessageHandler();
        commonEvents = new CommonEvents();
        fmlCommonEvents = new FMLCommonEvents();
        ServerPlayNetworking.registerGlobalReceiver((class_2960)WorldMapMessage.MAIN_CHANNEL, (ServerPlayNetworking.PlayChannelHandler)new ServerWorldMapPacketConsumer(messageHandler));
        ModCommonEvents modEvents = new ModCommonEvents();
        new WorldMapMessageRegister().register(messageHandler);
        commonEvents.register();
        serverPlayerTickHandler = new ServerPlayerTickHandler();
        if (WorldMap.commonConfig.registerStatusEffects) {
            new EffectsRegister().registerEffects();
        }
        SupportServerMods.check();
    }

    public void tryLoadLaterServer() {
        if (this.loadLaterDone) {
            return;
        }
        if (this.firstStageError != null) {
            throw new RuntimeException(this.firstStageError);
        }
        if (!this.loadLaterNeeded) {
            return;
        }
        this.loadLaterDone = true;
        worldmapServer.loadLater();
    }

    public boolean isLoaded() {
        return loaded;
    }

    public static void onSessionFinalized() {
        mapLimiter.onSessionFinalized();
        if (SupportMods.minimap()) {
            SupportMods.xaeroMinimap.onSessionFinalized();
        }
    }

    static {
        MINIMAP_COMPATIBILITY_VERSION = 24;
        LOGGER = LogManager.getLogger();
        fileLayoutID = "worldmap_fabric";
        guiTextures = new class_2960("xaeroworldmap", "gui/gui.png");
        globalVersion = 1;
        playerTrackerSystemManager = new PlayerTrackerSystemManager();
        modJAR = null;
    }
}

